@echo off

set dst=%SYSTEMDRIVE%\cmigrate

echo *************************************************
echo 		packer deploy
echo.
echo Script will do flow works
echo 1. remove old version of packer
echo 2. copy new packer.exe and config to SYSTEMDRIVE
echo 3. import CA
echo 4. install packer.exe as system service
echo 5. start packer service
echo *************************************************
echo.

echo *************************************************
echo 1. remove old version of packer
echo *************************************************
nssm-2.24\win64\nssm.exe>nul 2>nul stop packer
nssm-2.24\win64\nssm.exe>nul 2>nul remove packer confirm
timeout /t 3 /nobreak> nul
if exist %dst% (
	rd>nul 2>nul /Q/S %dst%
)
echo.

echo *************************************************
echo 2. copy new packer.exe and config to SYSTEMDRIVE
echo *************************************************
mkdir %dst%
mkdir "%dst%\log"
mkdir "%dst%\conf"
mkdir "%dst%\nssm-2.24"
xcopy /e "conf" "%dst%\conf"
xcopy /e "nssm-2.24" "%dst%\nssm-2.24"
xcopy "packer.exe" "%dst%"
xcopy "redhat.cer" "%dst%"
xcopy "sync64.exe" "%dst%"
echo.

echo *************************************************
echo 3. import CA
echo *************************************************
certutil -addstore -f -enterprise "TrustedPublisher" %dst%\redhat.cer
%dst%\sync64.exe c
ping 0.0.0.0 -n 5 > null
%dst%\sync64.exe %SYSTEMDRIVE%
echo .

echo *************************************************
echo 4. install packer.exe as system service
echo *************************************************
%dst%\nssm-2.24\win64\nssm.exe>nul 2>nul install packer %dst%\packer.exe start=automic
echo.

echo *************************************************
echo 5. start packer service
echo *************************************************
%dst%\nssm-2.24\win64\nssm.exe>nul 2>nul start packer

pause
