/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.producers;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.zip.GZIPInputStream;
import org.apache.tools.bzip2.CBZip2InputStream;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;
import org.vafer.jdeb.DataConsumer;
import org.vafer.jdeb.DataProducer;
import org.vafer.jdeb.mapping.Mapper;
import org.vafer.jdeb.producers.AbstractDataProducer;

public final class DataProducerArchive
extends AbstractDataProducer
implements DataProducer {
    private final File archive;

    public DataProducerArchive(File pArchive, String[] pIncludes, String[] pExcludes, Mapper[] pMappers) {
        super(pIncludes, pExcludes, pMappers);
        this.archive = pArchive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void produce(DataConsumer pReceiver) throws IOException {
        TarInputStream archiveInputStream = null;
        try {
            TarEntry entry;
            archiveInputStream = new TarInputStream(this.getCompressedInputStream(new FileInputStream(this.archive)));
            while ((entry = archiveInputStream.getNextEntry()) != null) {
                if (!this.isIncluded(entry.getName())) continue;
                if ((entry = this.map(entry)).isDirectory()) {
                    pReceiver.onEachDir(entry.getName(), entry.getLinkName(), entry.getUserName(), entry.getUserId(), entry.getGroupName(), entry.getGroupId(), entry.getMode(), entry.getSize());
                    continue;
                }
                pReceiver.onEachFile((InputStream)archiveInputStream, entry.getName(), entry.getLinkName(), entry.getUserName(), entry.getUserId(), entry.getGroupName(), entry.getGroupId(), entry.getMode(), entry.getSize());
            }
        }
        finally {
            if (archiveInputStream != null) {
                archiveInputStream.close();
            }
        }
    }

    private InputStream getCompressedInputStream(InputStream in) throws IOException {
        PushbackInputStream pin = new PushbackInputStream(in, 2);
        byte[] header = new byte[2];
        if (pin.read(header) != header.length) {
            throw new IOException("Could not read header");
        }
        if (header[0] == 31 && header[1] == -117) {
            pin.unread(header);
            return new GZIPInputStream(pin);
        }
        if (header[0] == 66 && header[1] == 90) {
            return new CBZip2InputStream((InputStream)pin);
        }
        throw new IOException("Unsupported archive format : " + this.archive);
    }
}

