/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.shaded.compress.compress.compressors.gzip;

import java.util.HashMap;
import java.util.Map;

public class GzipUtils {
    private static final Map compressSuffix = new HashMap();
    private static final Map uncompressSuffix = new HashMap();

    private GzipUtils() {
    }

    public static boolean isCompressedFilename(String filename) {
        String lower = filename.toLowerCase();
        int n = lower.length();
        for (int i = 2; i <= 5 && i < n; ++i) {
            if (!uncompressSuffix.containsKey(lower.substring(n - i))) continue;
            return true;
        }
        return false;
    }

    public static String getUncompressedFilename(String filename) {
        String lower = filename.toLowerCase();
        int n = lower.length();
        for (int i = 2; i <= 5 && i < n; ++i) {
            Object suffix = uncompressSuffix.get(lower.substring(n - i));
            if (suffix == null) continue;
            return filename.substring(0, n - i) + suffix;
        }
        return filename;
    }

    public static String getCompressedFilename(String filename) {
        String lower = filename.toLowerCase();
        int n = lower.length();
        for (int i = 4; i <= 5 && i < n; ++i) {
            Object suffix = compressSuffix.get(lower.substring(n - i));
            if (suffix == null) continue;
            return filename.substring(0, n - i) + suffix;
        }
        return filename + ".gz";
    }

    static {
        compressSuffix.put(".tar", ".tgz");
        compressSuffix.put(".svg", ".svgz");
        compressSuffix.put(".cpio", ".cpgz");
        compressSuffix.put(".wmf", ".wmz");
        compressSuffix.put(".emf", ".emz");
        uncompressSuffix.put(".tgz", ".tar");
        uncompressSuffix.put(".taz", ".tar");
        uncompressSuffix.put(".svgz", ".svg");
        uncompressSuffix.put(".cpgz", ".cpio");
        uncompressSuffix.put(".wmz", ".wmf");
        uncompressSuffix.put(".emz", ".emf");
        uncompressSuffix.put(".gz", "");
        uncompressSuffix.put(".z", "");
        uncompressSuffix.put("-gz", "");
        uncompressSuffix.put("-z", "");
        uncompressSuffix.put("_z", "");
    }
}

